package zguid

import (
	"crypto/md5"
	"fmt"

	"github.com/google/uuid"
)

func New() string {
	return uuid.NewString()
}
func V7() string {
	u, _ := uuid.NewV7()

	return u.String()
}

func Hash(a any) string {
	b := md5.Sum([]byte(fmt.Sprintf("%v", a)))

	return fmt.Sprintf("%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x", b[0], b[1], b[2], b[3], b[4], b[5], b[6], b[7], b[8], b[9], b[10], b[11], b[12], b[13], b[14], b[15])
}

func HashAny(a ...any) string {
	return Hash(fmt.Sprintf("%+v", a))
}
