package zs3

import (
	"bytes"
	"fmt"
	"io"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/s3"
)

type ZS3 struct {
	Buket string

	*s3.S3
}

type Object struct {
	Name        string
	Reader      io.ReadSeeker
	Bytes       []byte
	ContentType string
	ACL         string
}

func (z *ZS3) ZPutObject(o *Object) error {
	var body io.ReadSeeker

	if len(o.Name) == 0 {
		return fmt.Errorf("name empty")
	}

	if o.Reader != nil {
		body = o.Reader
	} else if len(o.Bytes) > 0 {
		body = bytes.NewReader(o.Bytes)
	} else {
		return fmt.Errorf("empty body")
	}

	s3Object := &s3.PutObjectInput{
		Bucket: aws.String(z.Buket),
		Key:    aws.String(o.Name),
		Body:   body,
	}

	if len(o.ContentType) > 0 {
		s3Object.ContentType = aws.String(o.ContentType)
	}

	if len(o.ACL) > 0 {
		s3Object.ACL = aws.String(o.ACL)
	}

	if _, err := z.PutObject(s3Object); err != nil {
		return err
	}

	return nil
}

func (z *ZS3) ZDeleteObject(name string) error {
	if _, err := z.DeleteObject(&s3.DeleteObjectInput{
		Bucket: aws.String(z.Buket),
		Key:    aws.String(name),
	}); err != nil {
		return err
	}

	return nil
}

func New(region, host, buket, key, secret string) *ZS3 {
	return &ZS3{
		Buket: buket,
		S3:    NewNative(region, host, key, secret),
	}
}

func NewNative(region, host, key, secret string) *s3.S3 {
	return s3.New(
		session.Must(session.NewSession()),
		aws.NewConfig().
			WithCredentials(credentials.NewStaticCredentials(key, secret, "")).
			WithEndpoint(host).
			WithRegion(region).
			WithS3ForcePathStyle(true),
	)
}
