package zuptime

import "time"

type ZUptime struct {
	sTime     time.Time
	justStart time.Duration
}

func Default() *ZUptime {
	return New(time.Minute)
}

func New(js time.Duration) *ZUptime {
	return &ZUptime{sTime: time.Now(), justStart: js}
}

func (z ZUptime) JustStart() bool {
	return time.Since(z.sTime) < z.justStart
}

func (z ZUptime) Seconds() int64 {
	return int64(time.Since(z.sTime).Seconds())
}

func (z ZUptime) Minutes() int64 {
	return int64(time.Since(z.sTime).Minutes())
}

func (z ZUptime) Hours() int64 {
	return int64(time.Since(z.sTime).Hours())
}

func (z ZUptime) Since() time.Duration {
	return time.Since(z.sTime)
}
