package zbytes

import (
	"bytes"
	"fmt"
	"sync"
)

type Buffer struct {
	Buff *bytes.Buffer
	Mu   *sync.Mutex
}

func NewBuffer() *Buffer {
	return &Buffer{
		Buff: bytes.NewBuffer(nil),
		Mu:   new(sync.Mutex),
	}
}

func (z *Buffer) Write(p []byte) (n int, err error) {
	z.Lock()
	defer z.Unlock()

	return z.Buff.Write(p)
}
func (z *Buffer) WriteRune(r rune) (n int, err error) {
	z.Lock()
	defer z.Unlock()

	return z.Buff.WriteRune(r)
}
func (z *Buffer) WriteByte(c byte) error {
	z.Lock()
	defer z.Unlock()

	return z.Buff.WriteByte(c)
}
func (z *Buffer) WriteString(s string) (n int, err error) {
	z.Lock()
	defer z.Unlock()

	return z.Buff.WriteString(s)
}
func (z *Buffer) WriteAny(a any) (n int, err error) {
	return z.WriteString(fmt.Sprintf("%v", a))
}

func (z *Buffer) Bytes() []byte {
	z.Lock()
	defer z.Unlock()

	return z.Buff.Bytes()
}
func (z *Buffer) String() string {
	z.Lock()
	defer z.Unlock()

	return z.Buff.String()
}
func (z *Buffer) Reset() {
	z.Lock()
	defer z.Unlock()

	z.Buff.Reset()
}
func (z *Buffer) Len() int {
	z.Lock()
	defer z.Unlock()

	return z.Buff.Len()
}

func (z *Buffer) Lock() {
	z.Mu.Lock()
}
func (z *Buffer) Unlock() {
	z.Mu.Unlock()
}

func (z *Buffer) Line(a any) {
	_, _ = z.WriteString(fmt.Sprintf("%v\n", a))
}

func (z *Buffer) Err(err error) {
	z.Line(err.Error())
}
