package zchronos

import (
	"fmt"
	"log"
	"time"
)

type ZChronos struct {
	Prefix      string
	StartTime   time.Time
	TruncateDur time.Duration
}

func New(prefix string, dur time.Duration) *ZChronos {
	return &ZChronos{
		Prefix:      prefix,
		StartTime:   time.Now(),
		TruncateDur: dur,
	}
}

func Default(prefix string) *ZChronos {
	return New(prefix, time.Millisecond*10)
}

func DefaultMillis(prefix string) *ZChronos {
	return New(prefix, time.Millisecond)
}

func DefaultSecond(prefix string) *ZChronos {
	return New(prefix, time.Second)
}

func (z *ZChronos) CopyWithReset() *ZChronos {
	return New(z.Prefix, z.TruncateDur)
}

func (z *ZChronos) Printf(format string, v ...any) *ZChronos {
	log.Printf("%v: %v; %v", z.Prefix, fmt.Sprintf(format, v...), time.Since(z.StartTime).Truncate(z.TruncateDur))

	return z
}

func (z *ZChronos) Errf(err error, format string, v ...any) {
	log.Printf("%vErr: %v; %v", z.Prefix, fmt.Sprintf(format, v...), err)
}

func (z *ZChronos) Err(err error) {
	log.Printf("%vErr: %v", z.Prefix, err)
}

func (z *ZChronos) Finish() {
	log.Println(z.FinishStr())
}

func (z *ZChronos) FinishRet() *ZChronos {
	log.Println(z.FinishStr())

	return z
}

func (z *ZChronos) FinishStr() string {
	return fmt.Sprintf("%v: finish at %v", z.Prefix, time.Since(z.StartTime).Truncate(z.TruncateDur))
}

func (z *ZChronos) Since() time.Duration {
	return time.Since(z.StartTime).Truncate(z.TruncateDur)
}

func (z *ZChronos) Reset() {
	z.StartTime = time.Now()
}
