package zre

import (
	"regexp"
)

var cache map[string]*regexp.Regexp

func init() {
	cache = make(map[string]*regexp.Regexp)
}

func New(s string) *regexp.Regexp {
	if r, ok := cache[s]; ok {
		return r
	}

	cache[s] = regexp.MustCompile(s)

	return cache[s]
}

func Replace(expr string, s, rep string) string {
	return New(expr).ReplaceAllString(s, rep)
}

func Match(expr, s string) bool {
	return New(expr).MatchString(s)
}

func FindAll(expr, s string) [][]string {
	return New(expr).FindAllStringSubmatch(s, -1)
}

func Find(expr, s string) string {
	return New(expr).FindString(s)
}

func FindSubmatch(expr, s string) []string {
	return New(expr).FindStringSubmatch(s)
}
