package zwg

import (
	"sync"
	"sync/atomic"
)

type Zwg struct {
	store *atomic.Int32
	wg    *sync.WaitGroup
}

func (w *Zwg) Add(delta int) {
	w.store.Add(int32(delta))
	w.wg.Add(delta)
}

func (w *Zwg) Inc() *Zwg {
	w.store.Add(1)
	w.wg.Add(1)

	return w
}

func (w *Zwg) IncDefer() func() {
	w.Inc()

	return func() {
		w.Done()
	}
}

func (w *Zwg) Done() {
	w.store.Add(-1)
	w.wg.Done()
}

func (w *Zwg) Wait() {
	w.wg.Wait()
}

func (w *Zwg) Val() int {
	return int(w.store.Load())
}

func (w *Zwg) IsEmpty() bool {
	return w.Val() == 0
}

func New() *Zwg {
	zwg := &Zwg{
		store: &atomic.Int32{},
		wg:    &sync.WaitGroup{},
	}

	return zwg
}
