package zatomic

import "sync/atomic"

type UInt64 struct {
	v *atomic.Uint64
}

func NewUInt64() *UInt64 {
	return &UInt64{v: &atomic.Uint64{}}
}

func (i *UInt64) Store(v int) {
	i.v.Store(uint64(v))
}

func (i *UInt64) Add(delta int) uint64 {
	return i.v.Add(uint64(delta))
}

func (i *UInt64) Inc() uint64 {
	return i.Add(1)
}

func (i *UInt64) Dec() uint64 {
	return i.Add(-1)
}

func (i *UInt64) Load() uint64 {
	return i.v.Load()
}
