package zdebug

import (
	"fmt"
	"log"
	"runtime"
	"strings"
	"time"

	"git.barsukov.pro/barsukov/zgo/zutils"
)

func NewMonitor(secs int) {
	go func() {
		var rtm runtime.MemStats
		var memMax uint64

		for {
			time.Sleep(time.Duration(secs) * time.Second)

			runtime.ReadMemStats(&rtm)

			mem := ((rtm.HeapIdle - rtm.HeapReleased) + (rtm.Alloc + rtm.HeapInuse)) / 1e6
			memMax = max(memMax, mem)

			log.Printf("ZDEBUG: MEM: %v; MEM_MAX: %v; OBJ: %v, GO: %v, GC: %v",
				mem,
				memMax,
				(rtm.Mallocs-rtm.Frees)/1e3,
				runtime.NumGoroutine(),
				rtm.NumGC,
			)
		}
	}()
}

func Trace() []string {
	var out []string

	pc := make([]uintptr, 10)
	runtime.Callers(2, pc)

	for i := range pc {
		if f := runtime.FuncForPC(pc[i]); f != nil {
			file, line := f.FileLine(pc[i])

			if strings.Contains(file, "go/pkg") {
				continue
			}

			out = append(out, fmt.Sprintf("%s:%d", f.Name(), line))
		}
	}

	return zutils.ArrayUnique(out)
}
