package zdb

import (
	"fmt"
	"reflect"

	"github.com/google/uuid"
	"github.com/jackc/pgx/v5"
	"github.com/jackc/pgx/v5/pgtype"
)

func (d *Pool) WAny(dst any, sql string, args ...any) error {
	return d.qAny(d.SrvMaster, dst, sql, args...)
}
func (d *Pool) Any(dst any, sql string, args ...any) error {
	return d.execWrapper(ConnModeSync, dst, func(conn *Conn, dst1 any) error {
		return d.qAny(conn, dst1, sql, args...)
	})
}
func (d *Pool) AnyAsync(dst any, sql string, args ...any) error {
	return d.execWrapper(ConnModeAsync, dst, func(conn *Conn, dst1 any) error {
		return d.qAny(conn, dst1, sql, args...)
	})
}

func (d *Pool) qAny(q *Conn, dst any, sql string, args ...any) error {
	var rows pgx.Rows
	var err error

	dstVal := reflect.ValueOf(dst)

	if !dstVal.IsValid() || (dstVal.Kind() == reflect.Ptr && dstVal.IsNil()) {
		return fmt.Errorf("destination must be a non nil pointer")
	}
	if dstVal.Kind() != reflect.Ptr {
		return fmt.Errorf("destination must be a pointer, got: %v", dstVal.Type())
	}

	if rows, err = q.Query(d.ctx, sql, args...); err != nil {
		return err
	}
	defer rows.Close()

	var out []map[string]any

	desc := rows.FieldDescriptions()

	for rows.Next() {
		r := map[string]any{}
		v, _ := rows.Values()

		for i, f := range desc {
			switch {
			case v[i] == nil:
				r[f.Name] = nil
			case f.DataTypeOID == pgtype.NumericOID:
				ff, _ := v[i].(pgtype.Numeric).Float64Value()
				r[f.Name] = ff.Float64
			case f.DataTypeOID == pgtype.UUIDOID:
				bb := v[i].([16]byte)
				u, _ := uuid.FromBytes(bb[:])
				r[f.Name] = u.String()
			default:
				r[f.Name] = v[i]
			}
		}

		out = append(out, r)
	}

	dstVal = dstVal.Elem()
	dstVal.Set(reflect.ValueOf(out))

	return nil
}
