package zdb

import (
	"context"
	"log"
	"sync"
	"sync/atomic"
	"time"
)

func New(ctx context.Context) *Pool {
	p := &Pool{
		ctx:             ctx,
		mu:              &sync.RWMutex{},
		slavesIter:      &atomic.Int64{},
		slavesAsyncIter: &atomic.Int64{},
		Continues:       []string{"connect", "EOF", "conflict with recovery", "context deadline exceeded"},
		ContinuesTry:    []string{"conflict with recovery"},
		TryOnError:      1,
		TryOnSleep:      time.Second,
		PingTimeout:     time.Second * 5,
		PingTry:         5,
	}
	p.startPing()

	return p
}

func NewDefault() *Pool {
	p := New(context.Background())
	p.logger = log.Default()

	return p
}

func NewMaster(conn string) *Pool {
	s := NewDefault()
	_ = s.NewConn(ConnModeMaster, conn)

	return s
}
