package zhttp

import (
	"encoding/json"
	"fmt"
	"net/http"
	"time"
)

var DefaultClient = &http.Client{Timeout: time.Second * 10}

type ZClient struct {
	httpClient *http.Client
}

type Config struct {
	Repit int
}

func New(c *http.Client) *ZClient {
	return &ZClient{httpClient: c}
}

func Default() *ZClient {
	return New(DefaultClient)
}

func (c *ZClient) Do(r *http.Request, try int, sleepDur time.Duration) (resp *http.Response, err error) {
	for i := 0; i < try; i++ {
		if resp, err = c.httpClient.Do(r); err != nil {
			if i+1 < try {
				time.Sleep(sleepDur)
			}

			continue
		}

		break
	}

	return
}

func (c *ZClient) GetEmpty(url string) error {
	var err error
	var resp *http.Response

	if resp, err = c.httpClient.Get(url); err != nil {
		return err
	}
	defer resp.Body.Close()

	if resp.StatusCode >= 200 && resp.StatusCode < 300 {
		return nil
	}

	return fmt.Errorf("status code: %v", resp.StatusCode)
}

func (c *ZClient) GetJson(target any, url string) error {
	var err error
	var resp *http.Response

	if resp, err = c.httpClient.Get(url); err != nil {
		return err
	}
	defer resp.Body.Close()

	return json.NewDecoder(resp.Body).Decode(&target)
}

func GetJson(target any, url string) error {
	return Default().GetJson(target, url)
}
func GetEmpty(url string) error {
	return Default().GetEmpty(url)
}
