//go:build go_json

package zjson

import (
	"unsafe"

	"github.com/goccy/go-json"
)

func ToBytes(obj any) ([]byte, error) {
	return json.Marshal(obj)
}

func ToString(obj any) (string, error) {
	if b, err := json.Marshal(obj); err != nil {
		return "", err
	} else {
		return *(*string)(unsafe.Pointer(&b)), err
	}
}

func ToStringSafe(obj any) (string, error) {
	if b, err := json.Marshal(obj); err != nil {
		return "", err
	} else {
		return string(b), err
	}
}

func MustBytes(obj any) []byte {
	b, _ := ToBytes(obj)
	return b
}

func MustString(obj any) string {
	b, _ := ToBytes(obj)

	return *(*string)(unsafe.Pointer(&b))
}

func MustStringSafe(obj any) string {
	b, _ := ToBytes(obj)

	return string(b)
}

func Pretty(i any) string {
	ss, _ := json.MarshalIndent(i, "", "  ")
	return string(ss)
}
