//go:build !go_json

package zjson

import (
	"encoding/json"
	"unsafe"
)

func ToBytes(obj any) ([]byte, error) {
	return json.Marshal(obj)
}

func ToString(obj any) (string, error) {
	var err error
	var b []byte

	if b, err = json.Marshal(obj); err != nil {
		return "", err
	}

	return *(*string)(unsafe.Pointer(&b)), nil
}

func ToStringSafe(obj any) (string, error) {
	var err error
	var b []byte

	if b, err = json.Marshal(obj); err != nil {
		return "", err
	}

	return string(b), err
}

func MustBytes(obj any) []byte {
	b, _ := ToBytes(obj)

	return b
}

func MustString(obj any) string {
	b, _ := ToBytes(obj)

	return *(*string)(unsafe.Pointer(&b))
}

func MustStringSafe(obj any) string {
	b, _ := ToBytes(obj)

	return string(b)
}

func Pretty(i any) string {
	ss, _ := json.MarshalIndent(i, "", "  ")

	return string(ss)
}
