package zquit

import (
	"log"
	"os"
	"os/signal"
	"syscall"
	"time"
)

type Pool struct {
	PostWaitDur time.Duration

	items []*ZQuit
}

func NewPool(postWaitDur time.Duration) *Pool {
	return &Pool{
		PostWaitDur: postWaitDur,
		items:       make([]*ZQuit, 0),
	}
}

func DefaultPool() *Pool {
	return NewPool(time.Second)
}

func (p *Pool) Add(z *ZQuit) {
	p.items = append(p.items, z)
}

func (p *Pool) PrintStat(sec int) {
	go func() {
		for {
			time.Sleep(time.Second * time.Duration(sec))

			s := ""
			for _, i := range p.items {
				s += i.GetStat() + "; "
			}
			log.Printf("ZQUIT: %s", s)
		}
	}()
}

func (p *Pool) Wait() {
	for _, i := range p.items {
		i.Wait()
	}
}

func (p *Pool) WaitInterruptPrePost(pre func(), post func()) {
	c := make(chan os.Signal, 1)
	signal.Notify(c, os.Interrupt, syscall.SIGTERM)
	<-c

	if pre != nil {
		pre()
	}

	for _, i := range p.items {
		i.Shutdown()
	}

	p.Wait()
	time.Sleep(p.PostWaitDur)

	if post != nil {
		post()
	}
}

func (p *Pool) WaitInterrupt() {
	p.WaitInterruptPrePost(nil, nil)
}
