package zdb

import (
	"fmt"

	"github.com/jackc/pgx/v5/pgxpool"
)

type Conn struct {
	*pgxpool.Pool

	Index   int
	Mode    connMode
	Alive   bool
	PingTry int
}

type connMode int

const (
	ConnModeMaster connMode = iota
	ConnModeSync
	ConnModeAsync
	connModePool
)

func (c connMode) String() string {
	switch c {
	case ConnModeMaster:
		return "master"
	case ConnModeSync:
		return "sync"
	case ConnModeAsync:
		return "async"
	case connModePool:
		return "pool"
	default:
		return "unknown"
	}
}

func (c Conn) ToString() string {
	return fmt.Sprintf("%s: %s:%d", c.Mode, c.Config().ConnConfig.Host, c.Config().ConnConfig.Port)
}
