//go:build zgo_debug

package zdb

import "log"

func logConnStat(conn *Conn) {
	log.Printf("\033[9%dm%s\u001B[0m -> idle: %d; acquired: %d, total: %d, max: %d, ratio: %0.2f",
		conn.Index+1,
		conn.ToString(),
		conn.Stat().IdleConns(),
		conn.Stat().AcquiredConns(),
		conn.Stat().TotalConns(),
		conn.Stat().MaxConns(),
		float64(conn.Stat().AcquiredConns())/float64(conn.Stat().MaxConns()),
	)
}
