package zdb

func (d *Pool) WExec(sql string, args ...any) error {
	return d.qExec(d.SrvMaster, sql, args...)
}

func (d *Pool) WExecQty(sql string, args ...any) (int, error) {
	return d.qExecQty(d.SrvMaster, sql, args...)
}

func (d *Pool) WExecNamed(sql string, args map[string]any) error {
	newSql, newArgs := d.prepare(sql, args)

	return d.qExec(d.SrvMaster, newSql, newArgs...)
}

func (d *Pool) WExecNamedQty(sql string, args map[string]any) (int, error) {
	newSql, newArgs := d.prepare(sql, args)

	return d.qExecQty(d.SrvMaster, newSql, newArgs...)
}

func (d *Pool) WExecOpts(opts Opts) error {
	sql, args := opts.Opts()
	newSql, newArgs := d.prepare(sql, args)

	return d.qExec(d.SrvMaster, newSql, newArgs...)
}

func (d *Pool) WExecOptsQty(opts Opts) (int, error) {
	sql, args := opts.Opts()
	newSql, newArgs := d.prepare(sql, args)

	return d.qExecQty(d.SrvMaster, newSql, newArgs...)
}

func (d *Pool) qExec(q *Conn, sql string, args ...any) error {
	_, err := q.Exec(d.ctx, sql, args...)

	return err
}

func (d *Pool) qExecQty(q *Conn, sql string, args ...any) (int, error) {
	s, err := q.Exec(d.ctx, sql, args...)
	if err != nil {
		return 0, err
	}

	return int(s.RowsAffected()), nil
}
