package zdb

import (
	"github.com/georgysavva/scany/v2/pgxscan"
)

func (d *Pool) WGet(dst any, sql string, args ...any) error {
	return d.qGet(d.SrvMaster, dst, sql, args...)
}
func (d *Pool) WGetNamed(dst any, sql string, args map[string]any) error {
	newSql, newArgs := d.prepare(sql, args)

	return d.qGet(d.SrvMaster, dst, newSql, newArgs...)
}
func (d *Pool) WGetOpts(dst any, opts Opts) error {
	sql, args := opts.Opts()
	newSql, newArgs := d.prepare(sql, args)

	return d.qGet(d.SrvMaster, dst, newSql, newArgs...)
}

func (d *Pool) Get(dst any, sql string, args ...any) error {
	return d.execWrapper(ConnModeSync, dst, func(q *Conn, dst1 any) error {
		return d.qGet(q, dst1, sql, args...)
	})
}
func (d *Pool) GetNamed(dst any, sql string, args map[string]any) error {
	return d.execWrapper(ConnModeSync, dst, func(q *Conn, dst1 any) error {
		newSql, newArgs := d.prepare(sql, args)

		return d.qGet(q, dst1, newSql, newArgs...)
	})
}
func (d *Pool) GetOpts(dst any, opts Opts) error {
	sql, args := opts.Opts()
	newSql, newArgs := d.prepare(sql, args)

	return d.execWrapper(ConnModeSync, dst, func(q *Conn, dst1 any) error {
		return d.qGet(q, dst1, newSql, newArgs...)
	})
}

func (d *Pool) GetAsync(dst any, sql string, args ...any) error {
	return d.execWrapper(ConnModeAsync, dst, func(q *Conn, dst1 any) error {
		return d.qGet(q, dst1, sql, args...)
	})
}
func (d *Pool) GetAsyncNamed(dst any, sql string, args map[string]any) error {
	return d.execWrapper(ConnModeAsync, dst, func(q *Conn, dst1 any) error {
		newSql, newArgs := d.prepare(sql, args)

		return d.qGet(q, dst1, newSql, newArgs...)
	})
}
func (d *Pool) GetAsyncOpts(dst any, opts Opts) error {
	sql, args := opts.Opts()
	newSql, newArgs := d.prepare(sql, args)

	return d.execWrapper(ConnModeAsync, dst, func(q *Conn, dst1 any) error {

		return d.qGet(q, dst1, newSql, newArgs...)
	})
}

func (d *Pool) qGet(q pgxscan.Querier, dst any, sql string, args ...any) error {
	return pgxscan.Get(d.ctx, q, dst, sql, args...)
}
