package zdb

import (
	"github.com/georgysavva/scany/v2/pgxscan"
)

func (d *Pool) WSelect(dst any, sql string, args ...any) error {
	return d.qSelect(d.SrvMaster, dst, sql, args...)
}
func (d *Pool) WSelectNamed(dst any, sql string, args map[string]any) error {
	newSql, newArgs := d.prepare(sql, args)

	return d.qSelect(d.SrvMaster, dst, newSql, newArgs...)
}
func (d *Pool) WSelectOpts(dst any, opts Opts) error {
	sql, args := opts.Opts()
	newSql, newArgs := d.prepare(sql, args)

	return d.qSelect(d.SrvMaster, dst, newSql, newArgs...)
}

func (d *Pool) Select(dst any, sql string, args ...any) error {
	return d.execWrapper(ConnModeSync, dst, func(conn *Conn, dst1 any) error {
		return d.qSelect(conn, dst1, sql, args...)
	})
}
func (d *Pool) SelectNamed(dst any, sql string, args map[string]any) error {
	return d.execWrapper(ConnModeSync, dst, func(conn *Conn, dst1 any) error {
		newSql, newArgs := d.prepare(sql, args)

		return d.qSelect(conn, dst1, newSql, newArgs...)
	})
}
func (d *Pool) SelectOpts(dst any, opts Opts) error {
	sql, args := opts.Opts()
	newSql, newArgs := d.prepare(sql, args)

	return d.execWrapper(ConnModeSync, dst, func(conn *Conn, dst1 any) error {
		return d.qSelect(conn, dst1, newSql, newArgs...)
	})
}

func (d *Pool) SelectAsync(dst any, sql string, args ...any) error {
	return d.execWrapper(ConnModeAsync, dst, func(conn *Conn, dst1 any) error {
		return d.qSelect(conn, dst1, sql, args...)
	})
}
func (d *Pool) SelectAsyncNamed(dst any, sql string, args map[string]any) error {
	return d.execWrapper(ConnModeAsync, dst, func(conn *Conn, dst1 any) error {
		newSql, newArgs := d.prepare(sql, args)

		return d.qSelect(conn, dst1, newSql, newArgs...)
	})
}
func (d *Pool) SelectAsyncOpts(dst any, opts Opts) error {
	sql, args := opts.Opts()
	newSql, newArgs := d.prepare(sql, args)

	return d.execWrapper(ConnModeAsync, dst, func(conn *Conn, dst1 any) error {
		return d.qSelect(conn, dst1, newSql, newArgs...)
	})
}

func (d *Pool) qSelect(q *Conn, dst any, sql string, args ...any) error {
	return pgxscan.Select(d.ctx, q, dst, sql, args...)
}
