package zjson

import (
	"bytes"
	"encoding/json"
	"unsafe"
)

func ToBytes(obj any) ([]byte, error) {
	return json.Marshal(obj)
}

func ToString(obj any) (string, error) {
	var err error
	var b []byte

	if b, err = json.Marshal(obj); err != nil {
		return "", err
	}

	return *(*string)(unsafe.Pointer(&b)), nil
}

func ToStringSafe(obj any) (string, error) {
	var err error
	var b []byte

	if b, err = json.Marshal(obj); err != nil {
		return "", err
	}

	return string(b), err
}

func ToBytesReader(obj any) (*bytes.Reader, error) {
	b, err := ToBytes(obj)
	if err != nil {
		return nil, err
	}

	return bytes.NewReader(b), nil
}

func Bytes(obj any) []byte {
	b, _ := ToBytes(obj)

	return b
}

func String(obj any) string {
	b, _ := ToBytes(obj)

	return *(*string)(unsafe.Pointer(&b))
}

func MustStringSafe(obj any) string {
	b, _ := ToBytes(obj)

	return string(b)
}

func BytesReader(obj any) *bytes.Reader {
	r, _ := ToBytesReader(obj)

	return r
}

func Pretty(i any) string {
	ss, _ := json.MarshalIndent(i, "", "  ")

	return string(ss)
}
