package zsem

import (
	"context"
	"runtime"

	"golang.org/x/sync/semaphore"
)

type ZSem struct {
	qty int

	Sem *semaphore.Weighted
}

func (s *ZSem) AcquireCtx(ctx context.Context) error {
	return s.Sem.Acquire(ctx, 1)
}

func (s *ZSem) AcquireNErr(n int) error {
	return s.Sem.Acquire(context.Background(), int64(n))
}

func (s *ZSem) AcquireN(n int) {
	_ = s.AcquireNErr(n)
}

func (s *ZSem) Acquire() {
	s.AcquireN(1)
}

func (s *ZSem) AcquireErr() error {
	return s.AcquireNErr(1)
}

func (s *ZSem) AcquireAll() {
	s.AcquireN(s.qty)
}

func (s *ZSem) Release() {
	s.Sem.Release(1)
}

func (s *ZSem) ReleaseN(n int) {
	s.Sem.Release(int64(n))
}

func (s *ZSem) ReleaseAll() {
	s.ReleaseN(s.qty)
}

func (s *ZSem) Wait() {
	s.AcquireAll()
	s.ReleaseAll()
}

func New(n int) *ZSem {
	return &ZSem{Sem: semaphore.NewWeighted(int64(n)), qty: n}
}

func Default() *ZSem {
	return New(runtime.NumCPU() * 2)
}
