package zatomic

import "sync/atomic"

type Int struct {
	v *atomic.Int32
}

func New() *Int {
	return &Int{v: &atomic.Int32{}}
}

func (i *Int) Store(v int) {
	i.v.Store(int32(v))
}

func (i *Int) Add(delta int) int {
	return int(i.v.Add(int32(delta)))
}

func (i *Int) Inc() int {
	return i.Add(1)
}

func (i *Int) Dec() int {
	return i.Add(-1)
}

func (i *Int) Load() int {
	return int(i.v.Load())
}

func (i *Int) LoadInverse() int {
	return i.Load() * -1
}
