package zdb

import (
	"errors"
	"strings"

	"github.com/jackc/pgx/v5"
)

var ErrNoRows = pgx.ErrNoRows

func IsEmpty(err error) bool {
	return errors.Is(err, ErrNoRows)
}

type Opts interface {
	Opts() (sql string, args map[string]any)
}

func remove[T comparable](slice []T, s int) []T {
	return append(slice[:s], slice[s+1:]...)
}

func contains(s string, sl []string) bool {
	for _, s2 := range sl {
		if strings.Contains(s, s2) {
			return true
		}
	}

	return false
}

type Logger interface {
	Printf(format string, v ...any)
}
